VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create Table"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Private Const MAX_PATH = 512
Private Const INVALID_HANDLE_VALUE = -1
 
Private Type FILETIME
  dwLowDateTime As Long
  dwHighDateTime As Long
End Type
 
Private Type WIN32_FIND_DATA
  dwFileAttributes As Long
  ftCreationTime As FILETIME
  ftLastAccessTime As FILETIME
  ftLastWriteTime As FILETIME
  nFileSizeHigh As Long
  nFileSizeLow As Long
  dwReserved0 As Long
  dwReserved1 As Long
  cFileName As String * MAX_PATH
  cAlternate As String * 14
End Type

Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

Private Sub Command1_Click()
   pdf.CreateNewPDFA (vbNullString) ' The ouput file is opened later

   Dim i, n, rowNum As Integer

   pdf.SetPageCoords (pcTopDown)
   pdf.SetResolution (300)

   Dim tbl As CPDFTable
   Set tbl = New CPDFTable

   Call tbl.CreateTable(pdf, 100, 4, 500#, 125#)
   Call tbl.SetBoxProperty(-1, -1, tbpBorderWidth, 1#, 1#, 1#, 1#)
   Call tbl.SetBoxProperty(-1, -1, tbpCellPadding, 5#, 5#, 5#, 5#)
   Call tbl.SetGridWidth(1#, 1#)
   Call tbl.SetFlags(-1, -1, tfUseImageCS)

   Dim h As Long
   Dim Path As String
   Dim FD As WIN32_FIND_DATA
   
   Path = "../../../test_files/images/"
   h = FindFirstFile(Path + "*.jpg", FD)
   If h = INVALID_HANDLE_VALUE Then
      pdf.FreePDF
      MsgBox "Test images not found!", vbExclamation, "Error"
      Exit Sub
   End If

   n = 1
   rowNum = tbl.AddRow(125#)
   Call tbl.SetCellImage(rowNum, 0, True, coCenter, coCenter, 0#, 0#, Path + FD.cFileName, 1)
   
   While FindNextFile(h, FD) <> 0
      If n = 4 Then
         rowNum = tbl.AddRow(100#)
         n = 0
      End If
      Call tbl.SetCellImage(rowNum, n, True, coCenter, coCenter, 0#, 0#, Path + FD.cFileName, 1)
      n = n + 1
   Wend
   Call FindClose(h)

   pdf.Append

   Call tbl.DrawTable(50#, 50#, 742#)
   While tbl.HaveMore
      pdf.EndPage
      pdf.Append
      Call tbl.DrawTable(50#, 50#, 742#)
   Wend
   pdf.EndPage


   ' We draw the same table again but this time with the flag tfScaleToRect
   Call tbl.SetFlags(-1, -1, tfScaleToRect Or tfUseImageCS)
   pdf.Append

   Call pdf.SetFont("Arial", fsRegular, 12#, True, cp1252)
   Call pdf.WriteText(50#, 50#, "The same table but the flag tfScaleToRect was set.")

   Call tbl.DrawTable(50#, 65#, 742#)
   While tbl.HaveMore
      pdf.EndPage
      pdf.Append
      Call tbl.DrawTable(50#, 50#, 742#)
   Wend
   pdf.EndPage

   Set tbl = Nothing

   ' A table stores errors and warnings in the error log
   Dim pdferr As TPDFError

   n = pdf.GetErrLogMessageCount()
   For i = 0 To n - 1
      Call pdf.GetErrLogMessage(i, pdferr)
      MsgBox pdferr.Message, vbExclamation, "Warning"
   Next i

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim outFile As String
      outFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(outFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", outFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
